/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.OriginsForge;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import io.github.apace100.origins.screen.GameHudRender;
import java.util.ArrayList;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class OriginsForgeClient {
    public static void initialize() {
        OriginsClient.register();
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> OriginsForgeClient::buildConfigScreen);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(OriginsForgeClient::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(event -> {
            OriginsClient.isServerRunningOrigins = OriginsForge.channel.isRemotePresent(event.getNetworkManager());
            OriginsForge.SHOULD_QUEUE_SCREEN = true;
        });
        MinecraftForge.EVENT_BUS.addListener(OriginsForgeClient::drawHud);
        MinecraftForge.EVENT_BUS.addListener(OriginsForgeClient::openOriginsScreen);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        OriginsClient.setup();
    }

    private static void openOriginsScreen(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.CLIENT && OriginsForge.SHOULD_QUEUE_SCREEN) {
            Minecraft.func_71410_x().func_213165_a(() -> {
                Minecraft instance = Minecraft.func_71410_x();
                Screen currentScreen = instance.field_71462_r;
                if (OriginsForge.SHOULD_QUEUE_SCREEN && currentScreen == null && instance.field_71439_g != null && instance.field_71441_e != null) {
                    OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)instance.field_71439_g);
                    ArrayList layers = OriginLayers.getLayers().stream().filter(layer -> layer.isEnabled() && !component.hasOrigin((OriginLayer)layer)).sorted().collect(Collectors.toCollection(ArrayList::new));
                    if (layers.isEmpty()) {
                        OriginsForge.SHOULD_QUEUE_SCREEN = false;
                        return;
                    }
                    instance.func_147108_a((Screen)new ChooseOriginScreen(layers, 0, true));
                    OriginsForge.SHOULD_QUEUE_SCREEN = false;
                }
            });
        }
    }

    private static void drawHud(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        for (GameHudRender hudRender : GameHudRender.HUD_RENDERS) {
            hudRender.render(event.getMatrixStack(), event.getPartialTicks());
        }
    }

    private static Screen buildConfigScreen(Minecraft minecraftClient, Screen parent) {
        return (Screen)AutoConfig.getConfigScreen(OriginsClient.ClientConfig.class, (Screen)parent).get();
    }
}

